
'Project: IB Metal Detector with a Resonator-Based Oscillator and Discriminator
'Bascom-Avr IDE [2.0.7.5]
'Author: Mahmood Alimohammadi
'Micro: ATmega8
'Date: 19 December, 2017
'Flash used:3648 Bytes
'******************************

$regfile = "m8adef.dat"
$crystal = 1000000

Config Lcd = 16 * 2
Config Lcdpin = Pin , Db4 = Portd.0 , Db5 = Portd.1 , Db6 = Portd.2 , Db7 = Portd.3 , E = Portd.4 , Rs = Portd.5

Config Timer1 = Pwm , Pwm = 10 , Prescale = 1 , Compare A Pwm = Clear Up

Config Adc = Single , Prescaler = Auto , Reference = Avcc
Config Single = Scientific , Digits = 2

Deflcdchar 0 , 32 , 32 , 31 , 31 , 31 , 31 , 32 , 32        ' bargraph
'-------------------------------
Declare Sub Adc5 : Declare Sub Pattern1 : Declare Sub Pattern2
Declare Sub Leds : Declare Sub Screen
'-------------------------------
Dim A As Word : Dim A1 As Single : Dim Graph As Byte : Dim I As Byte
Dim J As Byte : Dim Modes As Byte : Dim Steps As Byte
Dim Begin As Word : Dim Ends As Word
Dim Ledindex As Byte : Dim Temp As Word
'-------------------------------

Config Portb = Output : Config Portc.0 = Output
Config Portd.6 = Output : Config Portd.7 = Output
Config Portc.4 = Input : Portc.4 = 1
'-------------------------------
V Alias Pwm1a
Led1 Alias Portb.6 : Led2 Alias Portb.7
Led3 Alias Portd.6 : Led4 Alias Portd.7
Led5 Alias Portb.0 : Led6 Alias Portb.2
Led7 Alias Portb.3 : Led8 Alias Portb.4
Led9 Alias Portb.5 : Led10 Alias Portc.0
'-------------------------------
Start Adc
Pwm1a = 0
Modes = 1
Cls
Cursor Off
'-------------------------------

Nonferrous:

Do
If Pinc.4 = 0 Then Goto Ferrous

Modes = 1

Call Adc5
Steps = 10
Begin = 199
Call Pattern1
Call Screen
Loop

End
'-------------------------------

Ferrous:

Do
If Pinc.4 = 0 Then Goto Nonferrous

Modes = 2

Call Adc5
Steps = 10
Begin = 39
Call Pattern2
Call Screen
Loop

End
'--------------------------------

Sub Adc5
A = Getadc(5)
A = A / 2
A1 = A / 100
Led1 = 0 : Led2 = 0 : Led3 = 0 : Led4 = 0 : Led5 = 0
Led6 = 0 : Led7 = 0 : Led8 = 0 : Led9 = 0 : Led10 = 0

End Sub

Sub Screen
Locate 1 , 1
Lcd "Mode:" ; Modes ; "    "

Locate 1 , 9
Lcd "A:" ; A1 ; "         "

'Bargraph Display
For I = 1 To Graph

Locate 2 , I
Lcd Chr(0)
Next

'Clear Bargraph
For J = I To 16
Locate 2 , J
Lcd " "
Next
End Sub
'-------------------------------

Sub Pattern1
Graph = 0

If A < 200 Then V = 0
Ends = Begin + Steps
Ends = Ends + 1

If A > Begin And A < Ends Then
V = 350 : Led1 = 1 : Graph = 1
End If

For Ledindex = 2 To 15
Begin = Ends - 1
Ends = Ends + Steps

If A > Begin And A < Ends Then
Call Leds
End If

Next

Ends = Ends - 1

If A > Ends Then
V = 830 : Led10 = 1 : Graph = 16
End If

Waitms 50
End Sub
'------------------------------------

Sub Pattern2
Graph = 0

If A > 199 Then V = 0
Ends = Begin + Steps
Ends = Ends + 1

If A < Ends Then

Led10 = 1 : Graph = 16
End If

For Ledindex = 15 To 1 Step -1
Begin = Ends - 1
Ends = Ends + Steps

If A > Begin And A < Ends Then
Call Leds

End If

Next

Waitms 50
End Sub
'-----------------------------------

Sub Leds

Temp = Ledindex * 30
V = 350 + Temp
If Ledindex > 10 Then : Led10 = 1 : End If
Select Case Ledindex


Case Is = 1
Graph = 1 : Led1 = 1
Case Is = 2
Graph = 2 : Led2 = 1
Case Is = 3
Graph = 3 : Led3 = 1
Case Is = 4
Graph = 4 : Led4 = 1
Case Is = 5
Graph = 5 : Led5 = 1
Case Is = 6
Graph = 6 : Led6 = 1
Case Is = 7
Graph = 7 : Led7 = 1
Case Is = 8
Graph = 8 : Led8 = 1
Case Is = 9
Graph = 9 : Led9 = 1
Case Is = 10
Led10 = 1 : Graph = 10
Case Is = 11
Graph = 11
Case Is = 12
Graph = 12
Case Is = 13
Graph = 13
Case Is = 14
Graph = 14
Case Is = 15
Graph = 15


End Select

End Sub